import java.util.ArrayList;
import java.util.Collections;
import java.util.Scanner;
import java.io.File;
import java.io.FileWriter;

/**
 * Class that processes a text file and writes word frequency stats to another file.
 *   @author Dave Reed
 *  @version 9/3/13
 */
public class WordFrequencies {
    public static final String JUNK_FILE = "junkWords.txt";
    
    public static void main(String[] args) {
        Scanner input = new Scanner(System.in);
        
        System.out.print("Enter the name of the text file to be processed: ");
        String processFileName = input.next();
        String outputFileName = Utils.replaceExtension(processFileName, "out");
        
        ArrayList<Word> words = new ArrayList<Word>();
        ArrayList<String> ignoreWords = new ArrayList<String>();

        try {
            Scanner ignoreFile = new Scanner(new File(JUNK_FILE));
            while (ignoreFile.hasNext()) {
                ignoreWords.add(Utils.stripWord(ignoreFile.next().toLowerCase()));
            }
            ignoreFile.close();
            
            Scanner processFile = new Scanner(new File(processFileName));
            while (processFile.hasNext()) {
                String nextWord = Utils.stripWord(processFile.next().toLowerCase());
                if (nextWord.length() > 0 && !ignoreWords.contains(nextWord)) {
                    int index = Utils.findWord(nextWord, words);
                    if (index >= 0) {
                        words.get(index).increment();
                    }
                    else {
                        words.add(new Word(nextWord));
                    }
                }
            }
            processFile.close();
            
            Collections.sort(words, Word.FreqComparator);
        }
        catch (java.io.FileNotFoundException e) {
            System.out.println("FILE NOT FOUND");
        }
        
        try {
            FileWriter outputFile = new FileWriter(outputFileName);
            outputFile.write(processFileName);
            for (Word nextWord : words) {
                outputFile.write("\n" + nextWord);
            }
            outputFile.flush();
            outputFile.close();            
        }
        catch (java.io.IOException e) {
            System.out.println("COULD NOT WRITE TO FILE");
        }
    }
}