import java.util.Comparator;

/**
 * Class the encapsulates a word and its frequency count.
 *   @author Dave Reed
 *   @version 9/3/13
 */
public class Word {
    private String word;
    private int count;

    /** 
     * Constructs a Word object (with specified frequency).
     *   @param newWord the word being stored
     *   @param count the frequency count
     */
    public Word(String newWord, int count) {
        this.word = newWord;
        this.count = count;
    }

    /** 
     * Constructs a Word object (with frequency 1).
     *   @param newWord the word being stored
     */
    public Word(String newWord) {
        this(newWord, 1);
    }

    /**
     * Accessor method for the word.
     * @return the stored word
     */
    public String getWord() {
        return this.word;
    }

    /**
     * Accessor method for the frequency.
     * @return the frequency
     */
    public int getFrequency() {
        return this.count;
    }

    /**
     * Increments the frequency count for the word.
     */
    public void increment() {
        this.count++;
    }

    /**
     * Converts the Word object into a String ("WORD #").
     * @return the String representation
     */
    public String toString() {
        return this.getWord() + " " + this.getFrequency();
    }

    /**
     * Comparator for two Words (based on alphabet).
     */
    public static Comparator<Word> AlphaComparator = new Comparator<Word>() {
        public int compare(Word w1, Word w2) {
            if (w2.word.equals(w1.word)) {
                return (w2.count - w1.count);
            } else {
                return w1.word.compareTo(w2.word);
            }
        }

        public boolean equals(Word w1, Word w2) {
            return this.equals(w1, w2);
        }
    };


    /**
     * Comparator for two Words (based on frequency).
     */
    public static Comparator<Word> FreqComparator = new Comparator<Word>() {
        public int compare(Word w1, Word w2) {
            if (w2.count == w1.count) {
                return w2.word.compareTo(w1.word);
            } else {
                return (w2.count - w1.count);
            }
        }

        public boolean equals(Word w1, Word w2) {
            return this.equals(w1, w2);
        }
    };
}
