/**
 * Class the encapsulates a word and its frequency count.
 *   @author Dave Reed
 *   @version 9/3/13
 */
public class WordByFreq implements Comparable<WordByFreq> {
	private String word;
	private int count;

        /** 
         * Constructs a Word object (with specified frequency).
         *   @param newWord the word being stored
         *   @param count the frequency count
         */
	public WordByFreq(String newWord, int count) {
	    this.word = newWord;
	    this.count = count;
	}
        
        /** 
         * Constructs a Word object (with frequency 1).
         *   @param newWord the word being stored
         */
	public WordByFreq(String newWord) {
	    this(newWord, 1);
	}
        
        /**
         * Accessor method for the word.
         * @return the stored word
         */
	public String getWord() {
	    return this.word;
	}
	
        /**
         * Accessor method for the frequency.
         * @return the frequency
         */
	public int getFrequency() {
	    return this.count;
	}
	
        /**
         * Increments the frequency count for the word.
         */
	public void increment() {
	    this.count++;
	}
	
        /**
         * Converts the Word object into a String ("WORD #").
         * @return the String representation
         */
	public String toString() {
	    return this.getWord() + " " + this.getFrequency();
	}
        
        /**
         * Comparison method for two Words (based on frequency).
         * @param other the Word object being compared with this one
         * @return negative if this freq > other freq; 0 if =; positive if <
         */
        public int compareTo(WordByFreq other) {
            if (other.count == this.count) {
                return this.word.compareTo(other.word);
            } else {
                return (other.count - this.count);
            }
        }
}
