/**
 * Class the encapsulates a word and its frequency count.
 *   @author Dave Reed
 *   @version 9/3/13
 */
public class WordByAlpha implements Comparable<WordByAlpha> {
    private String word;
    private int count;
    
    /** 
     * Constructs a Word object (with specified frequency).
     *   @param newWord the word being stored
     *   @param count the frequency count
     */
    public WordByAlpha(String newWord, int count) {
        this.word = newWord;
        this.count = count;
    }

    /** 
     * Constructs a Word object (with frequency 1).
     *   @param newWord the word being stored
     */
    public WordByAlpha(String newWord) {
        this(newWord, 1);
    }

    /**
     * Accessor method for the word.
     * @return the stored word
     */
    public String getWord() {
        return this.word;
    }

    /**
     * Accessor method for the frequency.
     * @return the frequency
     */
    public int getFrequency() {
        return this.count;
    }

    /**
     * Increments the frequency count for the word.
     */
    public void increment() {
        this.count++;
    }

    /**
     * Converts the Word object into a String ("WORD #").
     * @return the String representation
     */
    public String toString() {
        return this.getWord() + " " + this.getFrequency();
    }
   
    /**
     * Comparison method for two Words (based on alphabetical ordering).
     * @param other the Word object being compared with this one
     * @return negative if this < other alphabetically; 0 if =; positive if >
     */
    public int compareTo(WordByAlpha other) {
        if (other.word.equals(this.word)) {
            return (other.count - this.count);
        } else {
            return this.word.compareTo(other.word);
        }
    }
}
