import java.util.ArrayList;
import java.util.Collections;
import java.util.Scanner;
import java.io.File;
import java.io.FileWriter;

/**
 * Program that generates a Tag Cloud Web page from a file of word frequency data.
 *   @author Dave Reed
 *   @version 9/3/13
 */
public class TagCloud {
    public static final int MAX_FONT_SIZE = 100;
    public static final int MIN_FONT_SIZE = 8;
    
    public static void main(String[] args) {
        Scanner input = new Scanner(System.in);
        
        System.out.print("Enter the word frequency file and the desired number of words: ");
        String processFileName = input.next();
        int numWords = input.nextInt();
        String outputFileName = Utils.replaceExtension(processFileName, "html");      
        String filename = "";
        
        ArrayList<WordByAlpha> words = new ArrayList<WordByAlpha>();
        
        try {
            Scanner processFile = new Scanner(new File(processFileName));
            filename = processFile.next();
            
            for (int i = 0; i < numWords; i++) {
                if (processFile.hasNext()) {
                    String nextWord = processFile.next();
                    int wordCount = processFile.nextInt();
                    words.add(new WordByAlpha(nextWord, wordCount));
                }
            }
            processFile.close();
        }
        catch (java.io.FileNotFoundException e) {
            System.out.println("FILE NOT FOUND");
        }
          
        try {
            FileWriter outputFile = new FileWriter(outputFileName);
            
            outputFile.write("<!doctype html>\n<html>\n" +
                             "<head>\n<title>Tag Cloud</title>\n</head>\n" +
                             "<body>\n<h3>Tag Cloud for " + filename + 
                             "</h3>\n<table border=1><tr><td>\n");
            
            if (words.size() > 0) {
                int max = words.get(0).getFrequency();
                Collections.sort(words);
                
                for (WordByAlpha nextWord : words) {
                    int wordCount = nextWord.getFrequency();
                    int fontSize = Math.max(MIN_FONT_SIZE, MAX_FONT_SIZE*wordCount/max);
                    outputFile.write("<span style='font-size:" + fontSize +"pt'>" + 
                                     nextWord.getWord() + "</span> &nbsp; \n");
                }
            }
            outputFile.write("</table>\n</body>\n</html>");
            outputFile.flush();
            outputFile.close();
        }
        catch (java.io.IOException e) {
            System.out.println("COULD NOT WRITE TO FILE");
        }
    }
    
    ////////////////////////////////////

    public static int findWord(String desiredWord, ArrayList<WordByAlpha> words) {
        for (int i = 0; i < words.size(); i++) {
            if (words.get(i).getWord().equals(desiredWord)) {
                return i;
            }
        }
        return -1;
    } 
}