import java.util.ArrayList;

/**
 * String & List utility methods
 *   @author Dave Reed
 *   @version 9/3/13
 */
public class Utils {
    public static String stripWord(String word) {
        String copy = "";
        for (int i = 0; i < word.length(); i++) {
            char ch = word.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                copy += ch;
            }
        }
        return copy;
    }
    
    public static String replaceExtension(String filename, String newExt) {
        int dotIndex = filename.lastIndexOf('.');
        if (dotIndex == -1) {
            dotIndex = filename.length();
        }
        return filename.substring(0,dotIndex+1) + newExt;  
    }
    
    public static <T1 extends Comparable<? super T1>, T2>  void 
          selectionSort(ArrayList<T1> items, ArrayList<T2> parallel) {
        for (int i = 0; i < items.size()-1; i++) {      
          int indexOfMin = i;                           
          for (int j = i+1; j < items.size(); j++) {    
            if (items.get(j).compareTo(items.get(indexOfMin)) < 0) {
              indexOfMin = j;
            }
          }

          T1 temp = items.get(i);                       
          items.set(i, items.get(indexOfMin));         
          items.set(indexOfMin, temp);     

          T2 tempP = parallel.get(i);                   
          parallel.set(i, parallel.get(indexOfMin));         
          parallel.set(indexOfMin, tempP);     
        }
    }
}
